;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 4 BYTE BINARY ADDITION USING ACEx.
;;
;;      [03] [02] [01] [00]	(NUM1)
;;   +  [11] [10] [09] [08]	(NUM2)
;;      -------------------
;; [14] [13] [12] [11] [10]	(RESULT)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Source code compatible to both ACE1101 and ACE1202.
;.DEVICE ACE1101
.DEVICE ACE1202


OFFSET	EQU	08H	; RAM address offset between NUM1 and NUM2
RESULT	EQU	10H	; RAM address offset between NUM1 and RESULT
OFLW	EQU	14H	; RAM address of overflow byte


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; Place NUM1 and NUM2 into RAM.
;; NUM1 RAM[3-0]= C3C2C1C0, NUM2 RAM[B-8]= C7C6C5C4
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	LD	00H, #0C0H	; LSByte of NUM1
	LD	01H, #0C1H	;
	LD	02H, #0C2H	;
	LD	03H, #0C3H	; MSByte of NUM1

	LD	08H, #0C4H	; LSByte of NUM2
	LD	09H, #0C5H	;
	LD	0AH, #0C6H	;
	LD	0BH, #0C7H	; MSByte of NUM2

	JSR	ADD4		; Perform addition

DONE:	JP	DONE		; Addition complete


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  4 Byte Addition
;;
;; NUM1 + NUM2 = OVERFLOW, RESULT => RAM[14], RAM[13-10]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ADD4:	CLR	X		; X pointer set to LSB of NUM1
	CLR	OFLW		; Clear RAM[14] for overflow
	RC			; Clear carry flag
ADD4L:	LD	A, [#OFFSET,X]	; A conatins 1 byte of NUM1 to be added
	ADC	A, [X]		; Added 1 byte of NUM1 to 1 byte of NUM2,
				; Result stored in A
	ST	A, [#RESULT,X]	; Store A into proper byte location of RESULT 
	INC	X		; X pointer set for next byte of NUM1
	IFEQ	X, #04h		; Has all bytes of NUM1 and NUM2 been added? 
	JP	ADD4C		; Yes, store overflow
	JP	ADD4L		; No, continue adding bytes

ADD4C:	RLC	OFLW		; Rotate carry in overflow
	RET			; Addition complete...


	END			; End assembly source file
