;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 16 BY 16 BIT DIVISION USING ACEx.
;;
;; IDEND_HI IDEND_LO / ISOR_HI ISOR_LO = QUOT_HI QUOT_LO, REM_HI REM_LO
;; [01]     [00]     / [03]    [02]    = [05]    [04]   , [07]   [06]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; SOURCE CODE IS COMPATIBLE TO BOTH ACE1101 AND ACE1202
;.DEVICE ACE1101
.DEVICE ACE1202


IDEND_LO	EQU	00H	; LOW BYTE OF DIVIDEND
IDEND_HI	EQU	01H	; HIGH BYTE OF DIVIDEND
ISOR_LO		EQU	02H	; RAM ADDRESS OF DIVISOR
ISOR_HI		EQU	03H	; RAM ADDRESS OF DIVISOR

QUOT_LO		EQU	04H	; LOW BYTE OF QUOTIENT
QUOT_HI		EQU	05H	; HIGH BYTE OF QUOTIENT
REM_LO		EQU	06H	; LOW BYTE OF REMAINDER
REM_HI		EQU	07H	; HIGH BYTE OF REMAINDER

TEMP_LO		EQU	08H	; LOW BYTE OF TEMPORARY TEST DIVIDEND
TEMP_HI		EQU	09H	; HIGH BYTE OF TEMPORARY TEST DIVIDEND


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; PLACE IDEND AND ISOR INTO RAM.
;; IDEND RAM[01-00]= E7E7, ISOR RAM[03-02]= 3D3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	CLR	QUOT_LO		; CLEAR RAM
	CLR	QUOT_HI		; CLEAR RAM
	CLR	REM_LO		; CLEAR RAM
	CLR	REM_HI		; CLEAR RAM
	CLR	X		; TRACKS NUMBER OF SHIFTS PERFORMED TO DIVIDEND

	LD	IDEND_LO, #0E7H	; LOADS DIVIDEND WITH VALUE
	LD	IDEND_HI, #0E7H	;
	LD	ISOR_LO, #03DH	; LOADS DIVISOR WITH VALE
	LD	ISOR_HI, #03DH	;
	RC			; CLEAR CARRY FLAG
	LD	TEMP_LO, IDEND_LO	; STORE DIVIDEND INTO TEMP LOCATION
	LD	TEMP_HI, IDEND_HI	;
	JSR	DIV1616		; PERFORM DIVISION
DONE:	JP	DONE		; DIVISION COMPLETE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  16 BY 16 BIT DIVISION
;;
;; IDEND / ISOR = QUOT AND REM => RAM[04-03], RAM[06-05]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DIV1616:
	INC	X		; INCREMENT COUNT
	RLC	TEMP_LO		; ROTATE MSB OF TEMP INTO CARRY
	RLC	TEMP_HI		;
	RLC	REM_LO		; ROTATE CARRY INTO LSB OF REMAINDER
	RLC	REM_HI		;
	
	LD	A, REM_HI
	IFGT	A, ISOR_HI	; IS HIGH BYTE OF REMAINDER > HIGH BYTE OF ISOR?
	JP	DIV1616S	; YES, DO SUBTRACTION
	IFEQ	A, ISOR_HI	; IS HIGH BYTE OF REMAINDER = HIGH BYTE OF ISOR?
	JP	CHK_EQ_LOW	; CHECK IF LOW BYTE IS EQUAL
	JP	REM_SMALLER
CHK_EQ_LOW:
	LD	A, REM_LO
	IFEQ	A, ISOR_LO	; NO, IS LOW BYTE OF REMAINDER = LOW BYTE OF DIVISOR?
	JP	DIV1616S	; YES, DO SUBTRACTION
	IFGT	A, ISOR_LO	; IS LOW BYTE OF REMAINDER > LOW BYTE OF DIVISOR?
	JP	DIV1616S	; YES, DO SUBTRACTION
REM_SMALLER:
	RC			; NO, CLEAR CARRY FLAG
	RLC	QUOT_LO		; ROTATE CARRY INTO LSB OF QUOTIENT
	RLC	QUOT_HI		;
	IFEQ	X, #010H	; HAVE WE SHIFTED THE LAST BIT OF DIVISOR?
	JP	DIV1616D	; YES, DIVISION DONE
	JMP	DIV1616		; NO, NEXT BIT

DIV1616S:
	SC			; SET CARRY
	RLC	QUOT_LO		; ROTATE CARRY INTO LSB OF QUOTIENT
	RLC	QUOT_HI		;
	RC			; CLEAR CARRY
	LD	A, REM_LO
	SUBC	A, ISOR_LO	; SUBTRACT DIVISOR FROM LOW BYTE OF REMAINDER
	ST	A, REM_LO	; STORE RESULT INTO LOW BYTE OF REMAINDER
	LD	A, REM_HI	; LOAD A WITH HIGH BYTE OF REMAINDER
	SUBC	A, ISOR_HI	; SUBTRACT DIVISOR FROM HIGH BYTE OF REMAINDER
	ST	A, REM_HI	; STORE RESULT INTO HIGH BYTE OF REMAINDER
	IFEQ	X, #010H	; HAVE WE SHIFTED THE LAST BIT OF DIVISOR?
	JP	DIV1616D	; YES, DIVISION DONE
	JMP	DIV1616		; NO, NEXT BIT

DIV1616D:
	RET			; DIVISION COMPLETE...

	END			; END ASSEMBLY SOURCE CODE FILE
	
