;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 16 BY 8 BIT DIVISION USING ACEx.
;;
;; IDEND_HI IDEND_LO / ISOR = QUOT_HI QUOT_LO, REM_HI REM_LO
;; [01]     [00]     / [02] = [04]    [03]   , [06]   [05]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; SOURCE CODE IS COMPATIBLE TO BOTH ACE1101 AND ACE1202
;.DEVICE ACE1101
.DEVICE ACE1202


IDEND_LO	EQU	00H	; LOW BYTE OF DIVIDEND
IDEND_HI	EQU	01H	; HIGH BYTE OF DIVIDEND
ISOR		EQU	02H	; RAM ADDRESS OF DIVISOR

QUOT_LO		EQU	03H	; LOW BYTE OF QUOTIENT
QUOT_HI		EQU	04H	; HIGH BYTE OF QUOTIENT
REM_LO		EQU	05H	; LOW BYTE OF REMAINDER
REM_HI		EQU	06H	; HIGH BYTE OF REMAINDER

TEMP_LO		EQU	07H	; LOW BYTE OF TEMPORARY TEST DIVIDEND
TEMP_HI		EQU	08H	; HIGH BYTE OF TEMPORARY TEST DIVIDEND


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; PLACE IDEND AND ISOR INTO RAM.
;; IDEND RAM[01-00]= E7E7, ISOR RAM[01]= 3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	CLR	QUOT_LO		; CLEAR RAM
	CLR	QUOT_HI		; CLEAR RAM
	CLR	REM_LO		; CLEAR RAM
	CLR	REM_HI		; CLEAR RAM
	CLR	X		; TRACKS NUMBER OF SHIFTS PERFORMED TO DIVIDEND

	LD	IDEND_LO, #0E7H	; LOADS DIVIDEND WITH VALUE
	LD	IDEND_HI, #0E7H	;
	LD	ISOR, #03DH	; LOADS DIVISOR WITH VALE
	RC			; CLEAR CARRY FLAG
	LD	TEMP_LO, IDEND_LO	; STORE DIVIDEND INTO TEMP LOCATION
	LD	TEMP_HI, IDEND_HI	;
	JSR	DIV168		; PERFORM DIVISION
DONE:	JP	DONE		; DIVISION COMPLETE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  16 BY 8 BIT DIVISION
;;
;; IDEND / ISOR = QUOT AND REM => RAM[04-03], RAM[06-05]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DIV168:	INC	X		; INCREMENT COUNT
	RLC	TEMP_LO		; ROTATE MSB OF TEMP INTO CARRY
	RLC	TEMP_HI		;
	RLC	REM_LO		; ROTATE CARRY INTO LSB OF REMAINDER
	RLC	REM_HI		;
	LD	A, REM_HI
	IFNE	A, #00H		; DOES REMAINDER HAVE A HIGH BYTE?
	JP	DIV168S		; YES, DO SUBTRACTION
	LD	A, REM_LO
	IFGT	A, ISOR		; IS REMAINDER LARGER THAN DIVISOR?
	JP	DIV168S		; YES, DO SUBTRACTION
	IFEQ	A, ISOR		; NO, IS REMAINDER EQUAL TO DIVISOR?
	JP	DIV168S		; YES, DO SUBTRACTION
	RC			; NO, CLEAR CARRY FLAG
	RLC	QUOT_LO		; ROTATE CARRY INTO LSB OF QUOTIENT
	RLC	QUOT_HI		;
	IFEQ	X, #010H	; HAVE WE SHIFTED THE LAST BIT OF DIVISOR?
	JP	DIV168D		; YES, DIVISION DONE
	JMP	DIV168		; NO, NEXT BIT

DIV168S:
	SC			; SET CARRY
	RLC	QUOT_LO		; ROTATE CARRY INTO LSB OF QUOTIENT
	RLC	QUOT_HI		;
	RC			; CLEAR CARRY
	SUBC	A, ISOR		; SUBTRACT DIVISOR FROM LOW BYTE OF REMAINDER
	ST	A, REM_LO	; STORE RESULT INTO LOW BYTE OF REMAINDER
	LD	A, REM_HI	; LOAD A WITH HIGH BYTE OF REMAINDER
	SUBC	A, #00		; SUBTRACT ZERO FROM HIGH BYTE OF REMAINDER
				; KEEPING TRACK OF BORROWS
	ST	A, REM_HI	; STORE RESULT INTO HIGH BYTE OF REMAINDER
	IFEQ	X, #010H	; HAVE WE SHIFTED THE LAST BIT OF DIVISOR?
	JP	DIV168D		; YES, DIVISION DONE
	JMP	DIV168		; NO, NEXT BIT

DIV168D:
	RET			; DIVISION COMPLETE...

	END			; END ASSEMBLY SOURCE CODE FILE
	
