;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 16 BY 16 BIT MULTIPLICATION USING ACEx.
;;
;; ICAND_HI ICAND_LO X IER_HI IER_LO  = RESULT HI RESULT 3 RESULT 2 RESULT LO
;; [01]     [00]     X [03]   [02]    = [07]      [06]     [05]     [04]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; SOURCE CODE IS COMPATIBLE TO BOTH ACE1101 AND ACE1202
;.DEVICE ACE1101
.DEVICE ACE1202


ICAND_LO	EQU	00H	; LOW BYTE OF MULTIPLICAND
ICAND_HI	EQU	01H	; HIGH BYTE OF MULTIPLICAND

IER_LO		EQU	02H	; MULTIPLIER
IER_HI		EQU	03H	; MULTIPLIER

PROD_1		EQU	04H	; LOW BYTE OF RESULT
PROD_2		EQU	05H	; 2nd BYTE OF RESULT
PROD_3		EQU	06H	; 3rd BYTE OF RESULT
PROD_4		EQU	07H	; HIGH BYTE OF RESULT

PPROD_1		EQU	08H	; LOW BYTE OF PARTIAL PRODUCT
PPROD_2		EQU	09H	; 2nd BYTE OF PARTIAL PRODUCT
PPROD_3		EQU	0AH	; 3rd BYTE OF PARTIAL PRODUCT
PPROD_4		EQU	0BH	; HIGH BYTE OF PARTIAL PRODUCT

BIT_PTR		EQU	0CH	; BIT POINTER FOR MULTIPLIER


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; PLACE ICAND AND IER INTO RAM.
;; ICAND RAM[01-00]= E7E7, IER RAM[03-02]= 3D3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	CLR	A		; CLEAR ACCUM
	CLR	BIT_PTR		; CLEAR RAM
	CLR	PROD_1		;
	CLR	PROD_2		;
	CLR	PROD_3		;
	CLR	PROD_4		;
	CLR	PPROD_1		;
	CLR	PPROD_2		;
	CLR	PPROD_3		;
	CLR	PPROD_4		;
	LD	ICAND_LO, #0E7H	; STORE MULTIPLICAND IN RAM
	LD	ICAND_HI, #0E7H	;
	LD	IER_LO, #03DH	; STORE MULTIPLIER IN RAM
	LD	IER_HI, #03DH	;
	JSR	MPY1616		; PERFORM MULTIPLICATION
DONE:	JP	DONE		; MULTIPLICATION COMPLETE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  16 BIT MULTIPLICATION
;;
;; ICAND X IER = RESULT, RESULT => RAM[7-4]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MPY1616:
	RRC	IER_HI		; SHIFT LSB OF MULTIPLIER INTO CARRY
	RRC	IER_LO		;
	IFC			; IS LSB = 1 ? 
	JSR	MPY1616PP	; YES, PERFORM PARTIAL PRODUCT ADDITION
	INC	BIT_PTR		; NO, INCREMENT BIT POINTER TO NEXT LOCATION
	IFEQ	BIT_PTR, #010H	; HAVE WE COMPLETED THE MULTIPLICATION
				; OF ALL 8 BITS?
	JP	MPY1616D	; YES, MULTIPLICATION COMPLETE
	JP	MPY1616		; NO, NEXT BIT
MPY1616D:
	RET			; MULTIPLICATION COMPLETE...


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  PARTIAL PRODUCT ADDITION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MPY1616PP:
	LD	PPROD_1, ICAND_LO	; LOAD MULTIPLICAND INTO PARTICAL PRODUCT
	LD	PPROD_2, ICAND_HI	;
	CLR	PPROD_3		; CLEAR UPPER BYTES OF PARTICAL PRODUCT
	CLR	PPROD_4		;
	LD	A, BIT_PTR	; BIT POINTER IS NOW THE NUMBER OF TIME TO
				; SHIFT THE PARTIAL PRODUCT
SHIFT:	IFEQ	A, #00H		; IS IT THE LAST SHIFT?
	JP	ADD2RSLT	; YES, ADD PARTIAL PRODUCT TO RESULT
	RC			; NO, CLEAR CARRY FLAG
	DEC	A		; DECREMENT COUNT
	RLC	PPROD_1		; SHIFT PARTICAL PRODUCT LEFT ONCE
	RLC	PPROD_2		; ROTATING THROUGH THE CARRY FLAG
	RLC	PPROD_3		;
	RLC	PPROD_4		;
	JP	SHIFT		; NEXT SHIFT
ADD2RSLT: 
	RC			; CLEAR CARRY
	LD	A, PPROD_1	; ADD PARTIAL PRODUCT TO RESULT
	ADC	A, PROD_1	;
	ST	A, PROD_1	;
	LD	A, PPROD_2	;
	ADC	A, PROD_2	;
	ST	A, PROD_2	;
	LD	A, PPROD_3	;
	ADC	A, PROD_3	;
	ST	A, PROD_3	;
	LD	A, PPROD_4	;
	ADC	A, PROD_4	;
	ST	A, PROD_4	;
	RET			; PARTIAL PRODUCT ADDITION COMPLETE...

	END			; END ASSEMBLY SOURCE CODE FILE
