;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 16 BY 8 BIT MULTIPLICATION USING ACEx.
;;
;; ICAND_HI ICAND_LO X IER  = RESULT HI RESULT MID RESULT LOW
;; [01]     [00]     X [02] = [05]      [04]       [03]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; SOURCE CODE IS COMPATIBLE TO BOTH ACE1101 AND ACE1202
;.DEVICE ACE1101
.DEVICE ACE1202


ICAND_LO	EQU	00H	; LOW BYTE OF MULTIPLICAND
ICAND_HI	EQU	01H	; HIGH BYTE OF MULTIPLICAND

IER		EQU	02H	; MULTIPLIER

PROD_LO		EQU	03H	; LOW BYTE OF RESULT
PROD_MID	EQU	04H	; MIDDLE BYTE OF RESULT
PROD_HI		EQU	05H	; HIGH BYTE OF RESULT

PPROD_LO	EQU	06H	; LOW BYTE OF PARTIAL PRODUCT
PPROD_MID	EQU	07H	; MIDDLE BYTE OF PARTIAL PRODUCT
PPROD_HI	EQU	08H	; HIGH BYTE OF PARTIAL PRODUCT

BIT_PTR		EQU	09H	; BIT POINTER FOR MULTIPLIER


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; PLACE ICAND AND IER INTO RAM.
;; ICAND RAM[01-00]= E7E7, IER RAM[02]= 3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	CLR	A		; CLEAR ACCUM
	CLR	BIT_PTR		; CLEAR RAM
	CLR	PROD_LO		;
	CLR	PROD_MID	;
	CLR	PROD_HI		;
	CLR	PPROD_LO	;
	CLR	PPROD_MID	;
	CLR	PPROD_HI	;
	LD	ICAND_LO, #0E7H	; STORE MULTIPLICAND IN RAM
	LD	ICAND_HI, #0E7H	;
	LD	IER, #03DH	; STORE MULTIPLIER IN RAM
	JSR	MPY168		; PERFORM MULTIPLICATION
DONE:	JP	DONE		; MULTIPLICATION COMPLETE


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  16 BY 8 BIT MULTIPLICATION
;;
;; ICAND X IER = RESULT, RESULT => RAM[5-3]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MPY168:	RRC	IER		; SHIFT LSB OF MULTIPLIER INTO CARRY
	IFC			; IS LSB = 1 ? 
	JSR	MPY168PP	; YES, PERFORM PARTIAL PRODUCT ADDITION
	INC	BIT_PTR		; NO, INCREMENT BIT POINTER TO NEXT LOCATION
	IFEQ	BIT_PTR, #08H	; HAVE WE COMPLETED THE MULTIPLICATION
				; OF ALL 8 BITS?
	JP	MPY168D		; YES, MULTIPLICATION COMPLETE
	JP	MPY168		; NO, NEXT BIT
MPY168D:
	RET			; MULTIPLICATION COMPLETE...


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  PARTIAL PRODUCT ADDITION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MPY168PP:
	LD	PPROD_LO, ICAND_LO	; LOAD MULTIPLICAND INTO PARTICAL PRODUCT
	LD	PPROD_MID, ICAND_HI	;
	CLR	PPROD_HI	; CLEAR HIGH BYTE OF PARTICAL PRODUCT
	LD	A, BIT_PTR	; BIT POINTER IS NOW THE NUMBER OF TIME TO
				; SHIFT THE PARTIAL PRODUCT
SHIFT:	IFEQ	A, #00H		; IS IT THE LAST SHIFT?
	JP	ADD2RSLT	; YES, ADD PARTIAL PRODUCT TO RESULT
	RC			; NO, CLEAR CARRY FLAG
	DEC	A		; DECREMENT COUNT
	RLC	PPROD_LO	; SHIFT PARTICAL PRODUCT LEFT ONCE
	RLC	PPROD_MID	; ROTATING THROUGH THE CARRY FLAG
	RLC	PPROD_HI	;
	JP	SHIFT		; NEXT SHIFT
ADD2RSLT: 
	RC			; CLEAR CARRY
	LD	A, PPROD_LO	; ADD PARTIAL PRODUCT TO RESULT
	ADC	A, PROD_LO	;
	ST	A, PROD_LO	;
	LD	A, PPROD_MID	;
	ADC	A, PROD_MID	;
	ST	A, PROD_MID	;
	LD	A, PPROD_HI	;
	ADC	A, PROD_HI	;
	ST	A, PROD_HI	;
	RET			; PARTIAL PRODUCT ADDITION COMPLETE...

	END			; END ASSEMBLY SOURCE CODE FILE
