;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FAIRCHILD SEMICONDUCTOR, MEMORY PRODUCTS GROUP
;;
;; SAMPLE CODE FOR 4 BYTE BINARY SUBTRACTION USING ACEx.
;;
;;      [0B] [0A] [09] [08]	(NUM2)
;;   -  [03] [02] [01] [00]	(NUM1)
;;      -------------------
;; [14] [13] [12] [11] [10]	(RESULT)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Source code compatible to both ACE1101 and ACE1202.
;.DEVICE ACE1101
.DEVICE ACE1202


OFFSET	EQU	08H	; RAM address offset between NUM1 and NUM2
RESULT	EQU	10H	; RAM address offset between NUM1 and RESULT
BRWO	EQU	14H	; RAM address of borrow byte


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MAIN ROUTINE
;;
;; Place NUM1 and NUM2 into RAM.
;; NUM2 RAM[0B-08]= E7E6E5E4, NUM1 RAM[03-00]= E3E2E1E0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

INIT:	LD	00H, #0E0H	; LSByte of NUM1
	LD	01H, #0E1H	;
	LD	02H, #0E2H	;
	LD	03H, #0E3H	; MSByte of NUM1

	LD	08H, #0E4H	; LSByte of NUM2
	LD	09H, #0E5H	;
	LD	0AH, #0E6H	;
	LD	0BH, #0E7H	; MSByte of NUM2

	JSR	SUB4		; Perform subtraction

DONE:	JP	DONE		; Subtraction complete


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SUBROUTINE:  4 Byte Subtraction
;;
;; NUM2 - NUM1 = BORROW, RESULT => RAM[14], RAM[13-10]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SUB4:	CLR	X		; Place X pointer to LSB of NUM1.
	CLR	BRWO		; Clear RAM[14] for carry location.
	RC			; Clear carry flag.
LOOP:	LD	A, [#OFFSET,X]	; A conatins 1 byte of NUM2 to be added.
	SUBC	A, [X]		; Subtract 1 byte of NUM1 from 1 byte of NUM2, result stored in A.
	ST	A, [#RESULT,X]	; Store the 1 byte result of subtraction into 1 byte of RESULT.
	INC	X		; Next byte to subtract.
	IFEQ	X, #04H		; Has all bytes of NUM1 and NUM2 been subtracted? 
				; If yes, check for negative number.
	JP	Borrow
	JP	LOOP
Borrow:	RLC	BRWO		; Rotate carry in borrow
	RET			; Subtraction complete...

	END			; End assembly source file

