/* Error handling
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __GPERROR_H__
#define __GPERROR_H__

void gperror(unsigned int code, char *message);
void gpwarning(unsigned int code, char *message);
void gpmessage(unsigned int code, char *message);

/* Error codes
 *
 * The error codes gpasm defines here are identical to MPASM's
 * definitions. gpasm doesn't use most of these btw. 
 * Additional gpasm definitions follow the last MPASM definition.
 *
 * FIXME - finish the GPE_codes enumeration.
 */
enum GPE_codes {
  GPE_ERROR            = 101,
  GPE_NOMEM            = 102,  //
  GPE_SYMFULL          = 103,  //
  GPE_TEMPFILE         = 104,  //
  GPE_NOENT            = 105,  // File or directory not found
  GPE_STRCPLX          = 106,
  GPE_BADDIGIT         = 107,
  GPE_BADCHAR          = 108,
  GPE_OPENPAR          = 109,  // Mis-matched open parenthesis
  GPE_CLOSEPAR         = 110,  // Mis-matched closed parenthesis
  GPE_MISSYM           = 111,  // No symbol in an EQU or SET
  GPE_NOOP             = 112,  // Missing an arithmetic operator
  GPE_NOSYM            = 113,  // Symbol has not been defined
  GPE_DIVBY0           = 114,
  GPE_DUPLAB           = 115,
  GPE_DIFFLAB          = 116,
  GPE_ADDROVF          = 117,  // address overflow
  GPE_ADDROVR          = 118,  // overwriting a previously written address
//GPE_                 = 119,
//GPE_                 = 120,
//GPE_                 = 121,
//GPE_                 = 122,
//GPE_                 = 123,
//GPE_                 = 124,
  GPE_RANGE            = 125,  // Argument out of range
//GPE_                 = 126,
//GPE_                 = 127,
//GPE_                 = 128,
//GPE_                 = 129,
//GPE_                 = 130,
//GPE_                 = 131,
//GPE_                 = 132,
  GPE_IHEX             = 133,  // Hex file format is too small for code
//GPE_                 = 134,
//GPE_                 = 135,
//GPE_                 = 136,
//GPE_                 = 137,
//GPE_                 = 138,
//GPE_                 = 139,
//GPE_                 = 140,
//GPE_                 = 141,
//GPE_                 = 142,
//GPE_                 = 143,
//GPE_                 = 144,
//GPE_                 = 145,
//GPE_                 = 146,
//GPE_                 = 147,
//GPE_                 = 148,
//GPE_                 = 149,
//GPE_                 = 150,
//GPE_                 = 151,
//GPE_                 = 152,
//GPE_                 = 153,
//GPE_                 = 154,
//GPE_                 = 155,
//GPE_                 = 156,
  GPE_UNKNOWN          = 157
};

/* Warning codes
 *
 * The warning codes gpasm defines here are identical to MPASM's
 * definitions. gpasm doesn't use most of these btw. 
 * Additional gpasm definitions follow the last MPASM definition.
 *
 * FIXME - finish the GPW_codes enumeration.
 */
enum GPW_codes {
  GPW_RANGE            = 202,  // Argument out of range
  GPW_EXPECTED         = 212,
  GPW_UNKNOWN          = 226
};

/* Message codes
 *
 * The message codes gpasm defines here are identical to MPASM's
 * definitions. gpasm doesn't use most of these btw. 
 * Additional gpasm definitions follow the last MPASM definition.
 *
 * FIXME - finish the GPM_codes enumeration.
 */
enum GPM_codes {
  GPM_USER             = 301,  // User supplied message
  GPM_BANK             = 302,  //
  GPM_RANGE            = 303,  //
  GPM_IDLOC            = 304,  //
  GPM_NOF              = 305,  //
  GPM_PAGE             = 306,  //
  GPM_PAGEBITS         = 307,  //
  GPM_SUPVAL           = 308,  //
  GPM_SUPLIN           = 309,  //
  GPM_SUPRAM           = 310,  //
//GPM_                 = 311,  // 
  GPM_EXTPAGE          = 312,  //
  GPM_CBLOCK           = 313,  //
  GPM_UNKNOWN          = 314   
};

#endif
