
/*  A Bison parser, made from parse.y
 by  GNU Bison version 1.27
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	LABEL	257
#define	IDENTIFIER	258
#define	CBLOCK	259
#define	ENDC	260
#define	NUMBER	261
#define	STRING	262
#define	HIGH	263
#define	LOW	264
#define	LSH	265
#define	RSH	266
#define	GREATER_EQUAL	267
#define	LESS_EQUAL	268
#define	EQUAL	269
#define	NOT_EQUAL	270
#define	LOGICAL_AND	271
#define	LOGICAL_OR	272
#define	ASSIGN_PLUS	273
#define	ASSIGN_MINUS	274
#define	ASSIGN_MULTIPLY	275
#define	ASSIGN_DIVIDE	276
#define	ASSIGN_MODULUS	277
#define	ASSIGN_LSH	278
#define	ASSIGN_RSH	279
#define	ASSIGN_AND	280
#define	ASSIGN_OR	281
#define	ASSIGN_XOR	282
#define	INCREMENT	283
#define	DECREMENT	284
#define	TBL_NO_CHANGE	285
#define	TBL_POST_INC	286
#define	TBL_POST_DEC	287
#define	TBL_PRE_INC	288

#line 1 "parse.y"

/* Parser for gpasm
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "gpasm.h"
#include "symbol.h"
#include "gperror.h"
#include "opcode.h"

void yyerror(char *message)
{
  gperror(103, message);
}

int yylex(void);

/************************************************************************/

/* Some simple functions for building parse trees */

static struct pnode *mk_pnode(enum pnode_tag tag)
{
  struct pnode *new = malloc(sizeof(*new));
  new->tag = tag;
  return new;
}

struct pnode *mk_constant(int value)
{
  struct pnode *new = mk_pnode(constant);
  new->value.constant = value;
  return new;
}

static struct pnode *mk_symbol(char *value)
{
  struct pnode *new = mk_pnode(symbol);
  new->value.symbol = value;
  return new;
}

static struct pnode *mk_string(char *value)
{
  struct pnode *new = mk_pnode(string);
  new->value.string = value;
  return new;
}

struct pnode *mk_list(struct pnode *head, struct pnode *tail)
{
  struct pnode *new = mk_pnode(list);
  new->value.list.head = head;
  new->value.list.tail = tail;
  return new;
}

static struct pnode *mk_2op(int op, struct pnode *p0, struct pnode *p1)
{
  struct pnode *new = mk_pnode(binop);
  new->value.binop.op = op;
  new->value.binop.p0 = p0;
  new->value.binop.p1 = p1;
  return new;
}

static struct pnode *mk_1op(int op, struct pnode *p0)
{
  struct pnode *new = mk_pnode(unop);
  new->value.unop.op = op;
  new->value.unop.p0 = p0;
  return new;
}

/************************************************************************/


#line 99 "parse.y"
typedef union {
  gpasmVal i;
  char *s;
  struct pnode *p;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		110
#define	YYFLAG		-32768
#define	YYNTBASE	54

#define YYTRANSLATE(x) ((unsigned)(x) <= 288 ? yytranslate[x] : 83)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    48,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    46,     2,     2,    51,    45,    19,     2,    52,
    53,    43,    41,    49,    42,     2,    44,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    50,     2,    17,
    24,    18,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    21,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    20,     2,    47,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    22,    23,    25,    26,    27,    28,    29,    30,    31,    32,
    33,    34,    35,    36,    37,    38,    39,    40
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     2,     6,    10,    15,    18,    20,    22,    25,
    29,    30,    38,    39,    46,    51,    52,    55,    57,    60,
    63,    67,    69,    73,    75,    79,    81,    85,    87,    89,
    91,    95,    97,    99,   103,   105,   107,   109,   113,   115,
   117,   119,   121,   125,   127,   129,   131,   133,   135,   137,
   139,   143,   145,   147,   149,   153,   155,   157,   159,   163,
   165,   167,   169,   171,   174,   176,   178,   180,   182,   184,
   186,   188,   190,   194,   196,   198,   200
};

static const short yyrhs[] = {    -1,
     0,    54,    55,    56,     0,    54,     1,    48,     0,     3,
    24,    65,    48,     0,     3,    57,     0,    57,     0,    48,
     0,     4,    48,     0,     4,    64,    48,     0,     0,     5,
    65,    48,    58,    60,     6,    48,     0,     0,     5,    48,
    59,    60,     6,    48,     0,     5,     1,     6,    48,     0,
     0,    60,    61,     0,    48,     0,    62,    48,     0,     3,
    48,     0,     3,    65,    48,     0,    63,     0,    62,    49,
    63,     0,     4,     0,     4,    50,    65,     0,    65,     0,
    65,    49,    64,     0,    66,     0,     8,     0,    68,     0,
    66,    67,    68,     0,    24,     0,    70,     0,    68,    69,
    70,     0,    22,     0,    23,     0,    72,     0,    70,    71,
    72,     0,    19,     0,    20,     0,    21,     0,    74,     0,
    72,    73,    74,     0,    17,     0,    18,     0,    15,     0,
    16,     0,    13,     0,    14,     0,    76,     0,    74,    75,
    76,     0,    11,     0,    12,     0,    78,     0,    76,    77,
    78,     0,    41,     0,    42,     0,    80,     0,    78,    79,
    80,     0,    43,     0,    44,     0,    45,     0,    82,     0,
    81,    82,     0,     9,     0,    10,     0,    42,     0,    46,
     0,    47,     0,     4,     0,     7,     0,    51,     0,    52,
    65,    53,     0,    43,     0,    38,     0,    39,     0,    40,
     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   131,   133,   135,   135,   141,   156,   216,   229,   238,   243,
   248,   251,   255,   258,   262,   269,   270,   277,   279,   281,
   286,   294,   296,   300,   305,   312,   317,   324,   326,   351,
   353,   360,   362,   364,   371,   371,   373,   375,   382,   382,
   382,   384,   386,   393,   393,   393,   393,   393,   393,   395,
   397,   404,   404,   406,   408,   415,   415,   417,   419,   426,
   426,   426,   428,   430,   437,   437,   437,   437,   437,   439,
   444,   449,   454,   459,   464,   469,   474
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","LABEL",
"IDENTIFIER","CBLOCK","ENDC","NUMBER","STRING","HIGH","LOW","LSH","RSH","GREATER_EQUAL",
"LESS_EQUAL","EQUAL","NOT_EQUAL","'<'","'>'","'&'","'|'","'^'","LOGICAL_AND",
"LOGICAL_OR","'='","ASSIGN_PLUS","ASSIGN_MINUS","ASSIGN_MULTIPLY","ASSIGN_DIVIDE",
"ASSIGN_MODULUS","ASSIGN_LSH","ASSIGN_RSH","ASSIGN_AND","ASSIGN_OR","ASSIGN_XOR",
"INCREMENT","DECREMENT","TBL_NO_CHANGE","TBL_POST_INC","TBL_POST_DEC","TBL_PRE_INC",
"'+'","'-'","'*'","'/'","'%'","'!'","'~'","'\\n'","','","':'","'$'","'('","')'",
"program","@1","line","statement","@2","@3","const_block","const_line","const_def_list",
"const_def","parameter_list","expr","e8","e8op","e7","e7op","e6","e6op","e5",
"e5op","e4","e4op","e3","e3op","e2","e2op","e1","e1op","e0", NULL
};
#endif

static const short yyr1[] = {     0,
    54,    55,    54,    54,    56,    56,    56,    57,    57,    57,
    58,    57,    59,    57,    57,    60,    60,    61,    61,    61,
    61,    62,    62,    63,    63,    64,    64,    65,    65,    66,
    66,    67,    68,    68,    69,    69,    70,    70,    71,    71,
    71,    72,    72,    73,    73,    73,    73,    73,    73,    74,
    74,    75,    75,    76,    76,    77,    77,    78,    78,    79,
    79,    79,    80,    80,    81,    81,    81,    81,    81,    82,
    82,    82,    82,    82,    82,    82,    82
};

static const short yyr2[] = {     0,
     0,     0,     3,     3,     4,     2,     1,     1,     2,     3,
     0,     7,     0,     6,     4,     0,     2,     1,     2,     2,
     3,     1,     3,     1,     3,     1,     3,     1,     1,     1,
     3,     1,     1,     3,     1,     1,     1,     3,     1,     1,
     1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
     3,     1,     1,     1,     3,     1,     1,     1,     3,     1,
     1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
     1,     1,     3,     1,     1,     1,     1
};

static const short yydefact[] = {     1,
     0,     0,     0,     4,     0,     0,     0,     8,     3,     7,
     0,     6,    70,    71,    29,    65,    66,    75,    76,    77,
    67,    74,    68,    69,     9,    72,     0,     0,    26,    28,
    30,    33,    37,    42,    50,    54,    58,     0,    63,     0,
    13,     0,     0,     0,    10,     0,    32,     0,    35,    36,
     0,    39,    40,    41,     0,    48,    49,    46,    47,    44,
    45,     0,    52,    53,     0,    56,    57,     0,    60,    61,
    62,     0,    64,     0,    16,    11,     5,    73,    27,    31,
    34,    38,    43,    51,    55,    59,    15,     0,    16,     0,
    24,     0,    18,    17,     0,    22,     0,    20,     0,     0,
    14,    19,     0,     0,    21,    25,    23,    12,     0,     0
};

static const short yydefgoto[] = {     1,
     3,     9,    10,    89,    75,    88,    94,    95,    96,    28,
    29,    30,    48,    31,    51,    32,    55,    33,    62,    34,
    65,    35,    68,    36,    72,    37,    38,    39
};

static const short yypact[] = {-32768,
    13,   -47,    26,-32768,    95,    17,     1,-32768,-32768,-32768,
    78,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    78,   -45,   -37,    -5,
   -16,    76,   131,    11,    -9,    94,-32768,    38,-32768,     9,
-32768,   -20,   -12,   -15,-32768,    78,-32768,   124,-32768,-32768,
   124,-32768,-32768,-32768,   124,-32768,-32768,-32768,-32768,-32768,
-32768,   124,-32768,-32768,   124,-32768,-32768,   124,-32768,-32768,
-32768,   124,-32768,    -2,-32768,-32768,-32768,-32768,-32768,   -16,
    76,   131,    11,    -9,    94,-32768,-32768,    31,-32768,    63,
     4,    10,-32768,-32768,     2,-32768,    88,-32768,    14,    78,
-32768,-32768,    62,    27,-32768,-32768,-32768,-32768,    80,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,    79,-32768,-32768,    15,-32768,-32768,     5,    52,
    -7,-32768,-32768,    59,-32768,    61,-32768,    58,-32768,    60,
-32768,    67,-32768,    55,-32768,    54,-32768,    89
};


#define	YYLAST		176


static const short yytable[] = {    42,
     4,    40,    45,    43,    13,    49,    50,    14,    15,    16,
    17,    46,   109,     2,    74,    -2,    -2,    -2,    47,    44,
    13,    63,    64,    14,    15,    16,    17,    76,     5,     6,
     7,    66,    67,    90,    91,    77,    92,    78,    18,    19,
    20,    13,    21,    22,    14,    87,    23,    24,    41,   102,
   103,    26,    27,   100,    18,    19,    20,   101,    21,    22,
    -2,   105,    23,    24,    25,    91,    13,    26,    27,    14,
    15,    16,    17,     8,   108,    18,    19,    20,    93,   110,
    22,    13,    99,    12,    14,    15,    16,    17,    26,    27,
    90,    91,   106,   104,    52,    53,    54,    79,     6,     7,
    18,    19,    20,    97,    21,    22,    80,   107,    23,    24,
    98,    81,    82,    26,    27,    18,    19,    20,    11,    21,
    22,    83,    85,    23,    24,    86,    73,    13,    26,    27,
    14,    84,    16,    17,     0,    93,    69,    70,    71,     0,
     0,     0,     8,    56,    57,    58,    59,    60,    61,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    18,    19,    20,     0,    21,    22,     0,     0,    23,
    24,     0,     0,     0,    26,    27
};

static const short yycheck[] = {     7,
    48,     1,    48,    11,     4,    22,    23,     7,     8,     9,
    10,    49,     0,     1,     6,     3,     4,     5,    24,    27,
     4,    11,    12,     7,     8,     9,    10,    48,     3,     4,
     5,    41,    42,     3,     4,    48,     6,    53,    38,    39,
    40,     4,    42,    43,     7,    48,    46,    47,    48,    48,
    49,    51,    52,    50,    38,    39,    40,    48,    42,    43,
    48,    48,    46,    47,    48,     4,     4,    51,    52,     7,
     8,     9,    10,    48,    48,    38,    39,    40,    48,     0,
    43,     4,    90,     5,     7,     8,     9,    10,    51,    52,
     3,     4,   100,     6,    19,    20,    21,    46,     4,     5,
    38,    39,    40,    89,    42,    43,    48,   103,    46,    47,
    48,    51,    55,    51,    52,    38,    39,    40,    24,    42,
    43,    62,    68,    46,    47,    72,    38,     4,    51,    52,
     7,    65,     9,    10,    -1,    48,    43,    44,    45,    -1,
    -1,    -1,    48,    13,    14,    15,    16,    17,    18,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    38,    39,    40,    -1,    42,    43,    -1,    -1,    46,
    47,    -1,    -1,    -1,    51,    52
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.27.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 134 "parse.y"
{ state.lst.line.was_org = state.org; state.lst.line.linetype = none; ;
    break;}
case 4:
#line 136 "parse.y"
{ 
	  next_line(0);
	;
    break;}
case 5:
#line 143 "parse.y"
{
	  gpasmVal value;

	  if (asm_enabled()) {
	    value = do_or_append_insn("set", mk_list(yyvsp[-1].p, NULL));
	    if (!state.mac_prev) {
	      set_global(yyvsp[-3].s, value, TEMPORARY, gvt_constant);
	    } else {
	      state.mac_body->label = yyvsp[-3].s;
	    }
	  }
	  next_line(value);
	;
    break;}
case 6:
#line 158 "parse.y"
{
	  if (state.lst.line.linetype == none)
	    state.lst.line.linetype = insn;
	  
	  if (asm_enabled()) {
	    if (state.mac_head) {
	      /* This is a macro definition.  Set it up */
	      struct symbol *mac;
	      struct macro_head *h = NULL;

	      mac = get_symbol(state.stMacros, yyvsp[-1].s);
	      if (mac)
		h = get_symbol_annotation(mac);

	      /* It's not an error if macro was defined on pass 1 and
		 we're in pass 2. */
	      if (h &&
		  !((h->pass == 1) && (state.pass == 2))) {
		char complaint[BUFSIZ];

		sprintf(complaint,
			"Attempt to redefine macro - first definition at line %d",
			h->line_number);
		gperror(118, complaint);
	      } else {
		if (!mac)
		  mac = add_symbol(state.stMacros, yyvsp[-1].s);
		annotate_symbol(mac, state.mac_head);
		h = state.mac_head;
		h->line_number = state.src->line_number;
	      }
	      h->pass = state.pass;

	      state.mac_head = NULL;
	    } else if (!state.mac_prev) {
	      /* Outside a macro, just define the label. */
	      switch (state.lst.line.linetype) {
	      case set:
		set_global(yyvsp[-1].s, yyvsp[0].i, TEMPORARY, gvt_constant);
		break;
	      case equ:
		set_global(yyvsp[-1].s, yyvsp[0].i, PERMANENT, gvt_constant);
		break;
	      case insn:
		set_global(yyvsp[-1].s, yyvsp[0].i << _16bit_core, PERMANENT, gvt_address);
		break;
	      default:
	      }
	    } else {
	      /* Inside a macro; add the label to the current line */
	      if (state.mac_body)
		state.mac_body->label = yyvsp[-1].s;
	    }
	  }
	    
	  /*printf("symbol  %s %s at line %d\n", $1, state.src->line_number);*/
	  next_line(yyvsp[0].i);
	;
    break;}
case 7:
#line 218 "parse.y"
{
	  if (state.mac_head) {
	    /* This is a macro definition, but the label was missing */
	    state.mac_head = NULL;
	    gperror(117, "Missing macro label");
	  } else {
	    next_line(0);
	  }
	;
    break;}
case 8:
#line 231 "parse.y"
{
	  if (!state.mac_prev) {
	    yyval.i = state.org;
	  } else {
	    macro_append();
	  }
	;
    break;}
case 9:
#line 240 "parse.y"
{
	  yyval.i = do_or_append_insn(yyvsp[-1].s, NULL);
	;
    break;}
case 10:
#line 245 "parse.y"
{
	  yyval.i = do_or_append_insn(yyvsp[-2].s, yyvsp[-1].p);
	;
    break;}
case 11:
#line 249 "parse.y"
{ begin_cblock(yyvsp[-1].p); next_line(0); ;
    break;}
case 12:
#line 252 "parse.y"
{
	  yyval.i = 0;
	;
    break;}
case 13:
#line 256 "parse.y"
{ next_line(0); ;
    break;}
case 14:
#line 259 "parse.y"
{
           yyval.i = 0;
        ;
    break;}
case 15:
#line 264 "parse.y"
{
	  yyval.i = 0;
  	;
    break;}
case 17:
#line 272 "parse.y"
{
	  next_line(0);
	;
    break;}
case 20:
#line 283 "parse.y"
{
	  cblock_expr(yyvsp[-1].s);
	;
    break;}
case 21:
#line 288 "parse.y"
{
	  cblock_expr_incr(yyvsp[-2].s, yyvsp[-1].p);
	;
    break;}
case 24:
#line 302 "parse.y"
{
	  cblock_expr(yyvsp[0].s);
	;
    break;}
case 25:
#line 307 "parse.y"
{
	  cblock_expr_incr(yyvsp[-2].s, yyvsp[0].p);
	;
    break;}
case 26:
#line 314 "parse.y"
{
	  yyval.p = mk_list(yyvsp[0].p, NULL);
	;
    break;}
case 27:
#line 319 "parse.y"
{
	  yyval.p = mk_list(yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 29:
#line 328 "parse.y"
{
	  /* Cook up the string, replacing \X with its code. */
	  char *ps, *pd;

	  ps = pd = yyvsp[0].s;
	  while (*ps) {
	    if (*ps != '\\') {
	      *pd++ = *ps++;
	    } else {
	      ps++; /* Go past the escape */
	      switch (*ps) {
	      case 'n':
		*pd++ = '\n';
		break;
	      }
	      ps++;
	    }
	  }
	  *pd = 0;
	  yyval.p = mk_string(yyvsp[0].s);
        ;
    break;}
case 31:
#line 355 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 34:
#line 366 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 38:
#line 377 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 43:
#line 388 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 51:
#line 399 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 55:
#line 410 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 59:
#line 421 "parse.y"
{
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	;
    break;}
case 64:
#line 432 "parse.y"
{
	  yyval.p = mk_1op(yyvsp[-1].i, yyvsp[0].p);
	;
    break;}
case 70:
#line 441 "parse.y"
{
	  yyval.p = mk_symbol(yyvsp[0].s);
        ;
    break;}
case 71:
#line 446 "parse.y"
{
	  yyval.p = mk_constant(yyvsp[0].i);
	;
    break;}
case 72:
#line 451 "parse.y"
{
	  yyval.p = mk_symbol("$");
	;
    break;}
case 73:
#line 456 "parse.y"
{
	  yyval.p = yyvsp[-1].p;
	;
    break;}
case 74:
#line 461 "parse.y"
{
	  yyval.p = mk_constant(TBL_NO_CHANGE);
	;
    break;}
case 75:
#line 466 "parse.y"
{
	  yyval.p = mk_constant(yyvsp[0].i);
	;
    break;}
case 76:
#line 471 "parse.y"
{
	  yyval.p = mk_constant(yyvsp[0].i);
	;
    break;}
case 77:
#line 476 "parse.y"
{
	  yyval.p = mk_constant(yyvsp[0].i);
	;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 481 "parse.y"

