;**********************************************************************************************
;             UART.INC - Configuration file for UARTS for Z8 Microcontrollers
;                             Copyright (C) 2000 ZiLOG, Inc
;                                 All rights reserved
;**********************************************************************************************
;	Assembler: ZDS V3.62
;	Best if viewed in Courier New 9 pt with 7 space tabs
;**********************************************************************************************
;=============================================================	
;	User Configurable values 
;=============================================================	

UART_TYPE	EQU	1	; 1 to select hardware UART, 0 to select software UART
					; NOTE: FOR SDK MAKE SURE HARDWARE JUMPERS R16 & R18 ARE CORRECT POSITION

BAUDRATE	EQU	9600	;Select a Baud Rate 1200,2400,9600, 19200 or 38400
					;38400 can be used ONLY with the hardware uart
                     		;These values are only valid for 12MHZ crystal 
                                
UART_SHARING	EQU	1	;FOR SW_UART ONLY - Select 1 to allow sharing of C/T and P3 A/D resource 
					;with the application.  The application must check the UART_BUSY
					;status bit to determine if the resources can be used at that
					;time. Selection of this option will increase the size of the
					;SW UART.  Also, SW UART data loss is possible if the resources
					;are not returned by the application in time for the next byte
					;Tx or RX.
									
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; UART SHARING 
;
; 12/7/99 - Only UART_BUSY status bit has been implemented for sharing.  The busy goes active
;           at start of Tx or Rx, and goes inactive at end of Tx or after 1 bit time delay folowing
;           end of Rx.  The one bit time delay is to permit back to back Rx chars without error.
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; !!!!! THE E136 EMULATOR HAS A BUG THAT PREVENT Tx INTERRUPTS FROM THE ASCI FROM OCCURRING  !!!!!!!
; !!!!! A WORKAROUND USED HERE IS TO USE T1 AS A BIT TIME COUNTER, LET IT BE SERVICED BY THE !!!!!!!
; !!!!! SAME SERVICE ROUTINE AS THE ASCI, AND USE IT TO TEST THE Tx STATUS FOR EMPTY.        !!!!!!!
; !!!!! ALL WORKAROUND CODE IS CONDITIONAL AND THE EMULATOR CONSTANT MUST BE SET TO 1 IN     !!!!!!!
; !!!!! UART.INC          8/20/00 MNG								  !!!!!!!
;													  !!!!!!!
					;								  !!!!!!!
EMULATOR	EQU	1		;Switch to enable workaround				  !!!!!!!
USE_TIMER	EQU	1		;Switch to enable use of T1 timer in workaround (recommended) !!!
;													  !!!!!!!
 IF UART_TYPE=1			;								  !!!!!!!
 IF EMULATOR=1			;								  !!!!!!!
	VECTOR	IRQ5 = HWUART_IRQ	;Vector for workaround					  !!!!!!!
 ENDIF					;								  !!!!!!!
 ENDIF					;								  !!!!!!!
					;								  !!!!!!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


                                
; DO NOT EDIT THIS FILE BELOW THIS LINE

;=============================================================	
;	Globals (Entry Labels, Variable Labels) 
;=============================================================	
	GLOBAL	INIT_UART,SEND_BYTE,UART_SVC   	;Program Entry Points for SW UART
	GLOBAL	START_RX,IRQ5_T1,HWUART_IRQ		;Interrupt Entry Points for SW UART
	GLOBAL	UART_FLAGS,TxDATA,RxDATA   		;Variable for SW UART

 IF UART_TYPE=0		;SW UART INTERRUPT VECTORS
 	VECTOR	IRQ0 = START_RX			;IRQ0 is Rx edge detect
	VECTOR	IRQ5 = IRQ5_T1			;T1 is SW_UART timebase

 ELSE				;HW UART INTERRUPT VECTORS
 	VECTOR	IRQ3 = HWUART_IRQ			;HW UART IRQ (for E13x)
 ENDIF

;*************************************************************
;	Software Uart Timer setting
;*************************************************************
;=============================================================	
;	Literals 
;=============================================================	

 IF	BAUDRATE=1200          	; SW UART Error is 0%

T1_BITTIMER		EQU	250		; Timer 1           (calculated value)
PRE1_BITTIMER		EQU	5		; Prescaler 1       (calculated value)
T1_H_BITTIMER		EQU	118		; 50% sample point  (measured value) 
HW_BAUD		EQU	154		; Hardware Uart timer	

 ENDIF


 IF	BAUDRATE=2400           ; SW UART Error is 0%

T1_BITTIMER		EQU	125		; Timer 1           (calculated value)
PRE1_BITTIMER		EQU	5		; Prescaler 1       (calculated value)
T1_H_BITTIMER		EQU	56		; 50% sample point  (measured value) 
HW_BAUD		EQU	76		; Hardware Uart timer

 ENDIF

 IF	BAUDRATE=9600           ; SW UART Error is +0.15%

T1_BITTIMER		EQU	39		; Timer 1           (calculated value)
PRE1_BITTIMER		EQU	4		; Prescaler 1       (calculated value)
T1_H_BITTIMER		EQU	10		; 50% sample point  (measured value) 
HW_BAUD		EQU	17		; Hardware Uart timer


 ENDIF
                          
 IF	BAUDRATE=19200          ; SW UART Error is +0.15%

T1_BITTIMER		EQU	26		; Timer 1           (calculated value)
PRE1_BITTIMER		EQU	3		; Prescaler 1       (calculated value)
T1_H_BITTIMER		EQU	1		; 50% sample point  (measured value) 
HW_BAUD		EQU	8		; Hardware Uart timer

 ENDIF

  IF	BAUDRATE=38400          

T1_BITTIMER		EQU	13		; Timer 1           (calculated value)
PRE1_BITTIMER		EQU	3		; Prescaler 1       (calculated value)
HW_BAUD		EQU	3		; Hardware Uart timer

 ENDIF

;***********************************************************
;	Hardware Uart Equ's
;***********************************************************                         
;  Hardware Baud rate selection table
;
;  Baud rate Selection using ASTH,ASTL BRG=1
;	ASTH,ASTL = (SCLK/2*Baud rate*(16(DR bit=0) or 64(DR bit=1))) -2

;
;	SCLK Clock 12Mhz
;	
;	38.4K		BRG=1, DR=0(/16) ASTH=00h, ASTL=03h (2.88)
;	19.2K		BRG=1, DR=0(/16) ASTH=00h, ASTL=08h (7.76)
;	9600		BRG=1, DR=0(/16) ASTH=00h, ASTL=11h (17.53)
;	2400		BRG=1, DR=0(/16) ASTH=00h, ASTL=4Ch (76.125)

ASCI:		EQU		0AH			;ASCI Register bank

TDR:		EQU		01H			;ASCI Transmit Data Register
RSR:		EQU		02H			;ASCI Receive Shift Register
CNTLA:		EQU		03H			;ASCI Control Register A
 MPE:			EQU		10000000b	;Multiprocessor Enable Bit
 											;	0 - Receive all Bytes  ( Reset State)
											;	1 - Filter Bytes with MPB = 0
 RE:			EQU		01000000b	;Receiver Enable
 											;	0 - ASCI Receiver Disabled ( Reset State)
											;	1 - ASCI Receiver Enabled (P30 = RX)
 TE:			EQU		00100000b	;Transmitter Enable
 											;	0 - ASCI Transmitter Disabled
											;	1 - ASCI Transmitter Enabled (P37 = TX)
 MPBR:			EQU		00001000b	;Multiprocessor Bit Received (Read Only)
 											;	0 - Multiprocessor Bit Not Received
											;	1 - Muttiprocessor Bit Received 
 EFR:			EQU		00001000b	;Error Flag Reset (Write Only)
 											;	0 - Clear Error Latches
											; 	1 - No Effect
 MOD2:			EQU		00000100b	;MOD2 Select Number of Data bits
 											; 	0 - 7 Data Bits (Reset State)	
											;	1 - 8 Data Bits
 MOD1:			EQU		00000010b	;MOD1 Parity Enable Control
 											;	0 - No Parity (Reset State)
											;	1 - Enable Parity 
 MOD0:			EQU		00000001b	;MOD0 Number of Stop Bits
 											;	0 - 1 Stop Bit	(Reset State)
											;	1 - 2 Stop Bits
CNTLB:		EQU		04H			;ASCI Control Register B
 MPBT:			EQU		10000000b	;Multiprocessor Bit Transmitter
 											;	0 - Transmit 0 in MPB (Reset State)
											;	1 - Transmit 1 in MPB 
 MP:			EQU		01000000b	;Multiprocessor Mode
 											;	0 - Multiprocessor mode Disabled (Reset State)
											;	1 - Multiprocessor mode Enabled
 PR:			EQU		00100000b	;Prescale (Write Only)
 											;	0 - BRG / by 10 (Reset State)
											;	1 - BRG / by 30
 PRO:			EQU		00010000b	;Parity Even/Odd
 											;	0 - Even Parity (Reset State)
											;	1 - Odd Parity
 DR:			EQU		00001000b	;Divide Ratio
 											;	0 - Divide by 16 (Reset State)
											;	1 - Divide by 64
 SS2_0:		EQU		00000111b	;Clock Source and Speed Bits 
 											;	210 
 SS_DIV_1:		EQU		00000000b	;	000 - Divide by 1
 SS_DIV_2:		EQU		00000001b	;	001 - Divide by 2
 SS_DIV_4:		EQU		00000010b	;	010 - Divide by 4
 SS_DIV_8:		EQU		00000011b	;	011 - Divide by 8
 SS_DIV_16:		EQU		00000100b	;	100 - Divide by 16
 SS_DIV_32:		EQU		00000101b	; 	101 - Divide by 32
 SS_DIV_64:		EQU		00000110b	;	110 - Divide by 64
									;	111 - Reserved (Reset State)
ASEXT:		EQU		05H			;ASCI Extension Control Register
 RX:			EQU		10000000b	;RX data state (Read Only)
 BRG:			EQU		00001000b	;Baud Rate Generator Mode
 											;	0 - Use Speed bits in reg 4  (Reset State)
											; 	1 - Use ASTH or ASTL value
 RIS:			EQU		00000100b	;RX Interrupt on Start Bit
 											;	0 - No IRQ on Start Bit (Reset State)
											;	1 - IRQ3 on Start Bit
 BD:			EQU		00000010b	;Break Detect (Read Only)
 											;	0 - Valid Data Byte
											;	1 - Break Detected
 SB:			EQU		00000001b	;Send Break
 											;	0 - Normal Operation (Reset State)
											;	1 - Send Break
ASTL:		EQU		06H			;ASCI Time Constant Register Low (Reset State FF)
ASTH:		EQU		07H			;ASCI Time Constant Register High (Reset State FF)
STAT:		EQU		08H			;ASCI Status Register
 RDRNE:		EQU		10000000b	;Receive Data Register Not Entry (Read Only)
 											;	0 - Receive FIFO Empty
											;	1 - Receive FIFO contains 1 or more Bytes
 OE:			EQU		01000000b	;Overrun Error (Read Only)
 											;	0 - Receive OK
											;	1 - Next Byte is a FIFO overrun
 PE:			EQU		00100000b	;Parity Error (Read Only)
 											;	0 - Parity OK
											;	1 - Parity Error
 FE:			EQU		00010000b	;Framing Error (Read Only)
 											; 	0 - Receive OK
											;	1 - Framing Error
 RIE:			EQU		00001000b	;Receiver Interrupt Enable
 											;	0 - No IRQ on Receive (Reset State)
											;	1 - IRQ3 on RDRNE going high or Start bit
 TDRE:			EQU		00000010b	;Transmit Data Register Empty (Read Only)
 											;	0 - Transmitter Working
											;	1 - Transmit Buffer Empty
 TIE:			EQU		00000001b	;Transmitter Interrupt Enable
 											;	0 - No IRQ on transmit (Reset State)
											;	1 - IRQ3 on TDRE going high

;************************************************************
;	Common Hardware/Software Equ's
;************************************************************
;=============================================================	
;	UART Flags - Intended to be globally accessable
;=============================================================
RxRDY		EQU	00000001B  	; D0=>1 = Done Receiving (data ready to be read)
TxRDY		EQU	00000010B	; D1=>1 = Done Transmitting (next data ready to be sent)
RX_FLAG	EQU	00000100B	; D2=>1 = Recieving (or transmitting if 0)
UART_IRQ	EQU	00001000B	; D3=>1 Set when UART done Tx or Rx, reset by IRQ svc  
UART_BUSY	EQU	00010000B	; D4=>1 Set when UART is running (SW UART) 
UART_DLY	EQU	00100000B	; D5=>1 Set when UART is stopping (resource sharing)
							;       to generate a 1 bit time delay in resetting UART_BUSY
							;       following a char Rx.
UART_ERROR	EQU	01000000B	; D6=> Set if UART (Rx) detects an error

